<?php

namespace App\Models;

use CodeIgniter\Model;

class OrganizationModel extends Model
{
    protected $table            = 'organizations';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = false;
    protected $protectFields    = true;
    protected $allowedFields    = [
        'nama_organisasi', 'jabatan', 'tahun_mulai', 'tahun_selesai',
        'deskripsi', 'urutan', 'created_at', 'updated_at'
    ];

    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    protected $allowCallbacks = true;
    protected $beforeInsert   = [];
    protected $afterInsert    = [];
    protected $beforeUpdate   = [];
    protected $afterUpdate    = [];
    protected $beforeFind     = [];
    protected $afterFind      = [];
    protected $beforeDelete   = [];
    protected $afterDelete    = [];

    public function searchAndFilter($search = '', $filter = [], $sort = 'urutan', $order = 'ASC')
    {
        $builder = $this->builder();

        if (!empty($search)) {
            $builder->groupStart()
                ->like('nama_organisasi', $search)
                ->orLike('jabatan', $search)
                ->orLike('deskripsi', $search)
                ->groupEnd();
        }

        if (!empty($filter['tahun_mulai'])) {
            $builder->where('tahun_mulai >=', $filter['tahun_mulai']);
        }

        if (!empty($filter['tahun_selesai'])) {
            $builder->where('tahun_selesai <=', $filter['tahun_selesai']);
        }

        $allowedSorts = ['urutan', 'nama_organisasi', 'jabatan', 'tahun_mulai', 'tahun_selesai'];
        $sort = in_array($sort, $allowedSorts) ? $sort : 'urutan';
        $order = strtoupper($order) === 'DESC' ? 'DESC' : 'ASC';

        $builder->orderBy($sort, $order);

        return $builder;
    }
}


